
;modif du 3 septembre 2008
;lecture du clavier et gestion du lcd
;infra rouge reconnaissance automatique: mode RC5, NEC, sharp ?
;pb lecture RAM



		LIST	P=16c64

		#INCLUDE	P16C64.INC

	__CONFIG _CP_OFF	& _XT_OSC & _WDT_OFF
	
;constantes
master		equ	0x0
adresse		equ	0x1		;module 1
cr		equ	0x0d
lf		equ	0x0a
;baud_rate	equ	0x20		;BAUDS = =19200, 20h=9600, =4800 , =2400, =1200
i2cSizeMask	equ	0x0F

;variables
; pour la routine div8 :
num		equ	0x20	;(nombre a diviser)
div		equ	num+1	;(diviseur)
result		equ	div+1	;(resultat)
reste		equ	result+1;(modulo : reste de la division s'il y en a)
;
; pour la routine 8toascii :
cent		equ	reste+1	;(chiffre des centaines)
diz		equ	cent+1	;(chiffre des dizaines)
unit		equ	diz+1	;(chiffre des unites)
;
temp1		equ	0x20	;ACCElsb+1
temp2		equ	temp1+1
temp		equ	temp2+1
tmp0		equ	temp+1
tmp1		equ	tmp0+1
tmp2		equ	tmp1+1
tmp3		equ	tmp2+1
compte		equ	tmp3+1
buffer		equ	compte+1
car232		equ	 buffer+1	;????
bufcar		equ	car232+1
speed		equ	bufcar+1
carlcd		equ	speed+1
pointeur	equ	carlcd+1		;pointeur dans le buffer acces indirect
lecteur		equ	pointeur+1	;pointeur pour lecture buffer acces indirect
flag		equ	lecteur+1	;bits d'tats, bit 0 = 1 = rs232 valide en emission devalide reception
							;car buffer plein
flag_ow		equ	flag+1		;one wire variables
cmpt		equ	flag_ow+1	; : 2 octets ?		(compteur interne)
bit_AB		equ	cmpt+2
bit_index	equ	bit_AB+1
OWBUFFER	equ	bit_index+1	;(variable servant au transfert sur le bus ONE WIRE)
OWBUFFER1	equ	OWBUFFER+1
OWBUFFER2	equ	OWBUFFER1+1
OWBUFFER3	equ	OWBUFFER2+1
OWBUFFER4	equ	OWBUFFER3+1
OWBUFFER5	equ	OWBUFFER4+1
OWBUFFER6	equ	OWBUFFER5+1
OWBUFFER7	equ	OWBUFFER6+1
OWBUFFER8	equ	OWBUFFER7+1
OWBUFFER9	equ	OWBUFFER8+1
OWBUFFER1a	equ	OWBUFFER9+1
OWBUFFER2a	equ	OWBUFFER1a+1
OWBUFFER3a	equ	OWBUFFER2a+1
OWBUFFER4a	equ	OWBUFFER3a+1
OWBUFFER5a	equ	OWBUFFER4a+1
OWBUFFER6a	equ	OWBUFFER5a+1
OWBUFFER7a	equ	OWBUFFER6a+1
OWBUFFER8a	equ	OWBUFFER7a+1
OWBUFFER9a	equ	OWBUFFER8a+1
c_dif		equ	OWBUFFER9a+1
c1_dif		equ	c_dif+1
flagx		equ	c1_dif+1
nb_ibuttons	equ	flagx+1
crc		equ	nb_ibuttons+1
					;fin one wire variables

touche		equ	crc+1

debbuf		equ	touche+1	;buffer RX = 32 octets pour acces indirect;finbuf		equ	0x6d


;adresses communes aux 3 banks
pclath_temp	equ	0x6e		;sauve pclath durant interruption
status_temp	equ	0x6f		;sauve status durant interruption
w_temp		equ	0x71		;4 banks communes sauve W durant interruption


; bits for variable flag
#define		rx0_tx1	 	0	; recoit rs232 clear transmet rs232 set
#define		car_ctrl 	1	; set caractere de control ou erreur pas ascii
#define		tx_lcd   	2	; a zero envoi caractere TX, a 1 envoi caractere LCD
#define		int	 	3	; set a 1 une interruption a eu lieu mesure incorrecte
#define		local	 	4	; fonctionnement local LCD,clavier,ir
#define		flag_IR	 	5	; commande IR
#define		erreur_ir 	6	; set erreur IR
#define		vide	 	7	;set = clavier clear IR

#define		fini		0	; pocessus complet rom search fini
#define		vrai		1	; rom search en cours donnes valable dans le buffer 8 octets
#define		v_bitd 		2	; valeur du bit de la premiere difference traite
#define		er_one_wire	3	;bit signalant une erreur dans rom_search
#define		er_crc		4	;bit signalant une erreur crc
#define		multidrop	5	;si ce bit est a 0 il n'y a qu'un ibutton sur le rseau

;********************************************************************
;io	port
#define		E_lcd		PORTD,1
#define		RS_lcd		PORTD,2
#define		RW_lcd		PORTD,3
#define		D4_lcd		PORTD,4
#define		D5_lcd		PORTD,5
#define		D6_lcd		PORTD,6
#define		D7_lcd		PORTD,7
			
; Definition du port et du bit sur lequel est install
; le ou les composants one wire
#define		OW_BUS		PORTB,5

;recepteur IR isop 1738
#define		IR		PORTB,7

;port rs232
#define		TX		PORTC,6
#define		RX		PORTC,7	;RBO pour rs232 sous interruption

;*********************************************************************
			
#define		FOSC		D'4000000'		; define FOSC to PICmicro
#define		I2CClock	D'400000'		 ; define I2C bite rate
#define		ClockValue	(((FOSC/I2CClock)/4) -1) ; 

; ****************************************************************************
; ****************************************************************************
; *									MACROS								 	 *
; ****************************************************************************
; ****************************************************************************

; La macro suivante rgle le BUS en sortie et y impose un niveau bas
; Attention : les macros de slections de banques doivent tres prsents
OW_BUS_OUT Macro
		bsf	STATUS,RP0		; Banque 1
		bcf	OW_BUS			; = sortie
		bcf	STATUS,RP0		; Banque 0
		bcf	OW_BUS			; = niveau bas
		endM

; La macro suivante rgle le BUS en entre (on "relche" le bus)
OW_BUS_IN Macro
		bsf	STATUS,RP0		; Banque 1
		bsf	OW_BUS			; = entre
		bcf	STATUS,RP0		; Banque 0
		endM
; ****************************************************************************

		org	0000h
		GOTO	INIT

		org	0004h
;		GOTO 	interrupt
		RETFIE

tabcom		ANDLW	b'00001111'	;0xF	
		ADDWF	PCL,F
		goto	ram_w		;0 write ram
		goto	ram_r		;1 read ram
		goto	eedata_w	;2 write eeprom
		goto	eedata_r	;3 read eeprom
		goto	prog_w		;4 write eeprog
		goto	prog_r		;5 read	eeprog
		goto	lcdcom_w	;6 commande le LCD
		goto	lcdcom_r	;7 lit l'tat du LCD
		goto	lcddat_w	;8 crit des donnes LCD
		goto	lcddat_r	;9 lit les donnes du LCD
		goto	rom_search1	;0Ah 10 identifie les priphriques one wire
		goto	r_match_R	;0Bh 11	lecture de la ram d'un DS18B20
		goto	r_match_W	;0Ch 12	criture dans la ram d'un DS18B20 
		goto	copy_EE		;0Dh 13 criture dans l'eeprom d'un DS18B20
		goto	recall_EE	;0Eh 14 l'ecture de l'eeprom d'un DS18B20
		goto	r_power		;0Fh 15 
;		goto	I2c_w		;14
;		goto	I2c_r		;15

HEX_DIG		ANDLW	b'00001111'	;0xF	
		ADDWF	PCL,F	
		RETLW	'0'
		RETLW	'1'
		RETLW	'2'
		RETLW	'3'
		RETLW	'4'
		RETLW	'5'
		RETLW	'6'
		RETLW	'7'
		RETLW	'8'
		RETLW	'9'
		RETLW	'A'
		RETLW	'B'
		RETLW	'C'
		RETLW	'D'
		RETLW	'E'
		RETLW	'F'

;***********************************************************************************
; ****************************************************************************
; *							Dbut des routines	one wire dallas							 *
; ****************************************************************************
;**************************************************************************************
; ****************************************************************************

; ****************************************************************************
; commande selection "match rom"
;*********************************************************************************
match_r		call	pr_2_dig	;commande 
		movwf	OWBUFFER1
		call	pr_2_dig	;commande 
		movwf	OWBUFFER2
		call	pr_2_dig	;commande 
		movwf	OWBUFFER3
		call	pr_2_dig	;commande 
		movwf	OWBUFFER4
		call	pr_2_dig	;commande 
		movwf	OWBUFFER5
		call	pr_2_dig	;commande 
		movwf	OWBUFFER6
		call	pr_2_dig	;commande 
		movwf	OWBUFFER7
		call	pr_2_dig	;commande 
		movwf	OWBUFFER8
match_rom
	; Step 1 : Reset pulse
		call	ResetBUS	;attend fin reset

	; Step 2 : match ROM Command
		movlw	H'55'		; match ROM = 55h
		movwf	OWBUFFER
		call	OW_WRITE8	; On evoie le buffer sur le bus

		movlw	8
		movwf	tmp1
		movlw	OWBUFFER1
		movwf	FSR
next3		movfw	INDF
		movwf	OWBUFFER
		call	OW_WRITE8
		incf	FSR,f
		decfsz	tmp1,f
		goto	next3
		return

; ****************************************************************************
; ****************************************************************************
	; Step 3 :;ordre de conversion et lecture du scratchpad
convert_T	movlw	H'44'		; Convert T = 44h
		movwf	OWBUFFER
		call	OW_WRITE8
	
	;On teste que la conversion soit termine
	;valable uniquement en alimentation exterieure
	;pas en mode parasite
	
Tstready	call	OW_READS	; On lance un read slot
		xorlw	D'1'		; on compare avec '1'
		btfss	STATUS, Z	; flag Z positionn si =
		goto	Tstready	; si non =, on reteste
; ****************************************************************************
; Routine de reset avec test
ResetBUS
		call	OW_RESET	; On fait un Reset
		xorlw	'Y'		; on vrifie qu'il se soit bien pass
		btfss	STATUS, Z
		goto	ResetBUS	; si on a pas eu 'y' on recommence		
		return

; ****************************************************************************
	
; ****************************************************************************
Read_scratchpad
		movlw	H'BE'		
		movwf	OWBUFFER
		call	OW_WRITE8

r_8bytes			; Lecture des x octets
		movlw	8
		movwf	tmp1
		movlw	OWBUFFER1
		movwf	FSR
next2		call	OW_READ8	; lecture du premier octet LSB
		movf	OWBUFFER, W
		movwf	INDF
		incf	FSR,f
		decfsz	tmp1,f
		goto	next2
		goto	ResetBUS
		
; ****************************************************************************
; ****************************************************************************

write_scratchpad
		movlw	H'4E'		; write scratchpad = 4Eh
		movwf	OWBUFFER
		call	OW_WRITE8
		movfw	OWBUFFER1	; premier octet
		movwf	OWBUFFER
		call	OW_WRITE8
		movfw	OWBUFFER2	; second octet
		movwf	OWBUFFER
		call	OW_WRITE8
		movfw	OWBUFFER3	; troisime octet : configuration 9 bits
		movwf	OWBUFFER
		call	OW_WRITE8
		goto	ResetBUS
		
; ****************************************************************************
; ****************************************************************************
; Routine de reset du bus ONE WIRE

; ****************************************************************************
; Routine de reset avec test
; ****************************************************************************

OW_RESET
; Premire tape : on force le bus  0 pendant au moins 480 s

		OW_BUS_OUT		; On rgle en sortie le bus ONE WIRE
		call	t480		; Temporisation de 480 S
		OW_BUS_IN		; On relache le bus ONE WIRE	
	
; Deuxime partie : on attend une rponse sur le bus
; On va tester pendant 60 S le bus
; on a 5 s par itrations, donc 60/5=12 (on teste 12 fois le BUS)

		movlw	D'12'		; initialisation du compteur
		movwf	cmpt
sub_reset	btfss	OW_BUS		; teste le bus :
		goto	Etape3		; si il n'est plus  1, c'est bon
		decfsz	cmpt,f		; si il est  1, on compte,
		goto	sub_reset	; puis on boucle
		retlw	'N'		; Si on a fini de compter sans succs, on renvoie
					; le caractre 'N' dans le registre W

; Troisime tape : on a eu un front descendant sur le bus, on doit valider
; alors un "presence pulse" en vrifiant qu'il dure au moins 60s
; on a 5 s par itrations, donc 60/5=12

Etape3		movlw	D'12'		; initialisation du compteur
		movwf	cmpt
sub_etape3	btfsc	OW_BUS		; teste le bus :
		retlw	'N'		; si il n'est plus  0, il y a un problme
		decfsz	cmpt,f		; si il est  0, on continue de compter
		goto	sub_etape3	; on boucle
					; Si on arrive  la fin du compteur : on a le temps
					; minimum, donc une "presence pulse" valide
		call	t480		; Temporisation de 480 S
		retlw	'Y'		; On termine en renvoyant 'Y'


; ****************************************************************************
; ****************************************************************************
; routine READ POWER doit rester colle a OW_READS
read_power	movlw	H'B4'		;retour w=0 parasite
		movwf	OWBUFFER	;=1 alim externe
		call	OW_WRITE8	;puis OW_READS et retour
		
; ****************************************************************************
	; Routine READ SLOT
	; initialisation du compteur pour la temporisation rglable
	
OW_READS	movlw	D'20'
		movwf	cmpt
		
	; Etape 1 :
	; La squence suivant impose un niveau bas sur le bus pendant au moins 1s
	; valeur de scurit = 6s (moiti du temps max)
	
		OW_BUS_OUT	; impose un niveau bas
		NOP
		NOP
		NOP
		NOP
		
	; Attention : deux cycles pris par la macro OW_BUS_IN avant
	; et aprs le changement d'impdance
	
		OW_BUS_IN	; Relache le bus
	; Etape 2 :
	; On va lire maintenant sur le bus  la 15e s
	
		NOP	
		NOP
		NOP
		
	; l'exemple suivant teste deux fois le bus (pour tre sr)
	
		movlw	D'0'
		btfsc	OW_BUS	; teste le bus
		movlw	D'1'	;ok niveau haut
		btfsc	OW_BUS	; teste le bus
		movlw	D'1'	;ok niveau haut
	
	; Etape 3 : on attend jusqu' la fin du slot et on laisse un recovery time
	; On utilise la tempo rglable car on ne doit pas changer le contenu de W
	
		goto	tempoo	; Fin de la routine


; ****************************************************************************
; ****************************************************************************
; Routine WRITE 1 SLOT

	; Etape 1
	; La squence suivante impose un niveau bas sur le bus pendant au moins 1s
	; valeur de scurit = 6s (moiti du temps max)
	
OW_WRITE1S	OW_BUS_OUT	; sortie, niveau bas
		NOP
		NOP
		NOP
		NOP
		
	; Attention : deux cycles pris par la macro OW_BUS_IN avant
	; et aprs le changement d'impdance
	
		OW_BUS_IN	; Relache le bus
	
	; Etape 2 : on attend jusqu' la fin du slot et on laisse un recovery time
	
		goto	t60			; tempo de 60 s
	
; ****************************************************************************
; ****************************************************************************
; Routine Write 0 Slot ( attention : 0 = zro, pas la lettre 'O' )
	
	; Etape 1 : on impose un niveau bas sur le bus pendant toute la dure du slot

OW_WRITE0S	OW_BUS_OUT
		call	t60
		OW_BUS_IN
	
	; Etape 2 : recovery time
	
		NOP
		NOP
		NOP
		NOP
		NOP
		return

; ****************************************************************************
; ****************************************************************************
; Routine Read 8 ( = lecture de 8 bits conscutifs )
; Rsultat dans OWBUFFER
;1er bit LSB

OW_READ8	movlw	D'8'		; initialisation du compteur
		movwf	cmpt+1
sub_READ8	call	OW_READS	; lecture (READ SLOT), renvoie 1 ou 0 dans W
		xorlw	D'1'		; on teste la valeur dans W : le flag Z est positionn
		bcf	STATUS, C	; on prpositionne le flag C  0
		btfsc	STATUS, Z	; on teste le flag Z :
		bsf	STATUS, C	; si il est  1, on positionne le flag C
		rrf	OWBUFFER, F	; et on fait un dcallage dans le buffer avec le flag C
		decfsz	cmpt+1,f
		goto	sub_READ8 	; et on boucle
		return

; ****************************************************************************
; ****************************************************************************
; Routine Write 8 ( = criture de 8 bits conscutifs )
; octet  crire dans OWBUFFER

OW_WRITE8	movlw	D'8'		; initialisation du compteur
		movwf	cmpt+1

	; la squence suivante teste un  un tous les bits de l'octet  envoyer
	; et choisit  chaque fois quel Write Slot utiliser
	;on commence par le LSB
	
sub_write8	btfsc	OWBUFFER, 0	; choix du Write slot
		call	OW_WRITE1S	
		btfss	OWBUFFER, 0	; choix du Write slot
		call	OW_WRITE0S
		rrf	OWBUFFER,f	; rotation pour tester le bit suivant
		decfsz	cmpt+1,f
		goto	sub_write8	; bouclage
		return

; ****************************************************************************
; ****************************************************************************
; Temporisations

; Temporisation de 480 s
; 3s par itrations, donc 160*3 = 480 s
; +2s pour l'initialisation (ngligeable)
t480		movlw	D'160'
		movwf	cmpt
sub_t480	decfsz	cmpt,f
		goto	sub_t480
		return

; Temporisation de 60 s
; 3s par itrations, donc 20*3 = 60 s
; +2s pour l'initialisation (ngligeable)

t60		movlw	D'20'
		movwf	cmpt
sub_t60		decfsz	cmpt,f
		goto	sub_t60
		return

; Temporisation rglabe : charger dans cmpt la valeur de la temporisation
; tempo = 3s*cmpt+2s

tempoo		decfsz	cmpt,f
		goto	tempoo
		return

;***********************************************************************************
;***************************************************************************************
	; scratchpad byte 2,3,4 => eprom
	
copy		movlw	H'48'
		movwf	OWBUFFER
		call	OW_WRITE8	; On evoie le buffer sur le bus
		goto	Tstready	;on sort de la routine

;***********************************************************************************
;***************************************************************************************
	;eprom => scrtchpad

recall		movlw	H'B8'
		movwf	OWBUFFER
		call	OW_WRITE8	; On envoie le buffer sur le bus
		goto	Tstready

;***************************************************************************************
;	routine de recherche sur le bus des ibuttons au retour un ibutton trouv ou erreur *
;***************************************************************************************
cancel		decf	c1_dif,f	;dans le cas d'un dja fait
		btfsc	STATUS,Z	;si a 1 une dif de moins
		goto	fn_search
		movfw	c1_dif		;derniere dif en cours
		movwf	c_dif		;pour memoire
rom_search
		bcf	flagx,multidrop
		movfw	OWBUFFER1a
		movwf	OWBUFFER1		
		movfw	OWBUFFER2a
		movwf	OWBUFFER2		
		movfw	OWBUFFER3a
		movwf	OWBUFFER3		
		movfw	OWBUFFER4a
		movwf	OWBUFFER4		
		movfw	OWBUFFER5a
		movwf	OWBUFFER5		
		movfw	OWBUFFER6a
		movwf	OWBUFFER6		
		movfw	OWBUFFER7a
		movwf	OWBUFFER7		
		movfw	OWBUFFER8a
		movwf	OWBUFFER8		
		clrw
		movwf	bit_index
		movwf	c1_dif		;difference en cours
		bcf	flagx,vrai
	
	; Step 1 : Reset pulse
		call	ResetBUS
		xorlw	'Y'		; on compare avec 'Y'
		btfsc	STATUS,Z
		goto	err_ibuton

	; Step 2 : ROM Command
		incf	bit_index,f
		movlw	H'F0'		; ROM search = F0h
		movwf	OWBUFFER
		call	OW_WRITE8	; On evoie le buffer sur le bus
s1		clrw
		movwf	bit_AB
		call	OW_READS	; On lance un read slot pour bit A
		xorlw	D'1'		; on compare avec '1'
		btfss	STATUS, Z	; flag Z positionn si =
		bsf	bit_AB,0	; bit A =1
		call	OW_READS	; On lance un read slot pour bit B
		xorlw	D'1'		; on compare avec '1'
		btfss	STATUS, Z	; flag Z positionn si =
		bsf	bit_AB,1	; bit B =1
		movlw	D'0'		; bits A et B = 1 ?	
		xorwf	bit_AB,W	; bits A et B = 1 ?
		btfsc	STATUS, Z	; flag Z positionn si =
		goto	fin_searc

		movlw	D'3'		; bits A et B = 0 ?
		xorwf	bit_AB,W	; bits A et B = 0 ?
		btfsc	STATUS, Z	; flag Z positionn si =
		goto	conflit		;

		btfsc	bit_AB,0	;test etat du bit A ????
		goto	wb0

wb1		call	OW_WRITE1S	;on ecrit un 1
		bsf	STATUS,C	;preset carry
		goto	s2

wb11		btfsc	OWBUFFER1,0	;dif en cours tat du bit prcdemment
		goto	cancel
		bsf	flagx,v_bitd	;etat du bit derniere dif
		goto	wb1
	
wb00		bcf	flagx,fini	
		bcf	flagx,v_bitd	;etat du bit derniere dif

wb0		call	OW_WRITE0S
		bcf	STATUS,C	;preclear carry
s2		rrf	OWBUFFER8,f
		rrf	OWBUFFER7,f
		rrf	OWBUFFER6,f	
		rrf	OWBUFFER5,f
		rrf	OWBUFFER4,f
		rrf	OWBUFFER3,f
		rrf	OWBUFFER2,f
		rrf	OWBUFFER1,f
		incf	bit_index,f
		movlw	.65
		xorwf	bit_index,w		; on compare avec index
		btfss	STATUS,Z
		goto s1

fin_searc	btfss	flagx,v_bitd	;etat du bit derniere dif
		goto	f_search
		decf	c1_dif,f		;si a 1 une dif de moins
		btfsc	STATUS,Z
		bsf	flagx,fini		;dernier trouv = done
f_search	btfss	flagx,multidrop		;si a zero un seul ibutton
		bsf	flagx,fini		;premier et dernier trouv = done
			movfw	c1_dif			;derniere dif en cours
		movwf	c_dif			;pour memoire
		bsf	flagx,vrai
		call	calc_crc		;non donc calcul crc
		bsf	flagx,er_crc
		movfw	OWBUFFER8	
		xorwf	crc,f
		btfss	STATUS,Z		;erreur crc ?
		goto	err_ibuton		;erreur crc
		movfw	OWBUFFER1
		movwf	OWBUFFER1a		
		movfw	OWBUFFER2
		movwf	OWBUFFER2a		
		movfw	OWBUFFER3
		movwf	OWBUFFER3a		
		movfw	OWBUFFER4
		movwf	OWBUFFER4a		
		movfw	OWBUFFER5
		movwf	OWBUFFER5a		
		movfw	OWBUFFER6
		movwf	OWBUFFER6a		
		movfw	OWBUFFER7
		movwf	OWBUFFER7a		
		movfw	OWBUFFER8
		movwf	OWBUFFER8a		
		bcf	flagx,er_crc
		goto	ResetBUS	;avec retour

fn_search	bsf	flagx,er_one_wire	;dernier trouv = erreur
		goto	ResetBUS		;on sort de la routine

err_ibuton	bsf	flagx,er_one_wire
		goto	ResetBUS		;avec retour
conflit		bsf	flagx,multidrop	;signale plusieurs ibuttons sur le rseau
		incf	c1_dif,f
		movfw	c_dif		;derniere dif
		subwf	c1_dif,w	;compteur en cours
		btfsc	STATUS,Z	;dif en cours = derniere dif
		goto	wb11		;oui bit 1
		btfsc	STATUS,C	;dif en cours > derniere dif ?
		goto	wb00		;oui on met un zero
						;dif en cours < derniere dif
		btfsc	OWBUFFER1,0	;dif en cours tat du bit prcdemment
		goto 	wb1
		goto	wb0


;********************************************
;calcul du crc ds18b20

calc_crc	movlw	0
		movwf	crc			;init crc
		movfw	OWBUFFER1
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		call	crc_x
		movfw	OWBUFFER2
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		call	crc_x
		movfw	OWBUFFER3
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		call	crc_x
		movfw	OWBUFFER4
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		call	crc_x
		movfw	OWBUFFER5
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		call	crc_x
		movfw	OWBUFFER6
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		call	crc_x
		movfw	OWBUFFER7
		movwf	c1_dif
		movlw	8
		movwf	tmp0
		goto	crc_x		;avec retour

;*************************************************************************************************
;*************************************************************************************************
;*************************************************************************************************

;***********************************************************************************
;routine de calcul du crc d'un octet
;***********************************************************************************
crc_x		movfw	crc		;pour 1 bit
		btfss	crc,0
		goto	crc0

crc1		bcf	STATUS,C	;crc bit=1
		rrf	c1_dif,f
		btfss	STATUS,C
		goto	xor1
		goto	xor0

crc0		bcf	STATUS,C	;crc bit=0
		rrf	c1_dif,f
		btfss	STATUS,C
		goto	xor0
xor1		rrf	crc,f		;crc xor input bit=1
		bsf	crc,7
		btfss	crc,3
		goto	setbit3	
		bcf	crc,3	
x1		btfss	crc,2
		goto	setbit2	
		bcf	crc,2
		goto	fin_crc
setbit3		bsf	crc,3	
		goto	x1
setbit2		bsf	crc,2	
		goto	fin_crc

xor0		rrf	crc,F		;crc xor input bit=0
		bcf	crc,7
		btfss	crc,3
		goto	clrbit3	
		bsf	crc,3	
x0		btfss	crc,2
		goto	clrbit2	
		bsf	crc,2
		goto	fin_crc
clrbit3		bcf	crc,3
		goto	x0
clrbit2		bcf	crc,2
fin_crc		decf	tmp0,F
		btfss	STATUS,Z
		goto	crc_x
		return	

;****************************************************************************
;***********************   fin one wire   ***********************************
;****************************************************************************
;***********************   routines de calcul   *****************************
;****************************************************************************
; premiere partie : la division par 100 pour avoir le chiffre des centaines	

ascii8		movwf	num
		movlw	D'100'
		movwf	div
		call	div8
	
; on enregistre la valeur dans la variable approprie et on prpare le resultat
; du modulo pour la division suivante
		movf	result, W
		movwf	cent
		movf	reste, W

; deuxime partie : on divise par 10 pour avoir le chiffre des dizaines
		movwf	num
		movlw	D'10'
		movwf	div
		call	div8

; on recupere le resultat qu'on stocke dans la variable appropriee et le resultat
; du modulo est le chiffre des unites qui sera lui aussi enregistre dans la variable
; appropriee
		movf	result, W
		movwf	diz
		movf	reste, W
		movwf	unit

; troisieme partie : transformation en caractere ASCII (masque)
		movlw	B'00110000'	; masque correspondant aux nombres decimaux dans la table ASCII
		iorwf	cent,F
		iorwf	diz,F
		iorwf	unit,F
		return

;****************************************************************************
;***********************   routine de division 8 bits   *********************
;****************************************************************************

div8		clrf	result		;initialisation des variables
		clrf	reste
					; routine principale de division
main_div	incf	result,F	; incrementer le resultat
		movf	div,W		; soustraire du nombre le diviseur
		subwf	num,F		
		btfss	STATUS,Z	; tester le bit Z, 0 -> teste carry, 1 -> aller sub_div
		btfss	STATUS,C	; tester le carry, 0 -> aller sub_div, 1 -> recommencer
		goto	sub_div					
		goto	main_div				

sub_div		btfsc	STATUS,C	; on teste le carry, si =1, le resultat est 0, on peut quitter
		return
	
		decf	result,F	; et si on a carry =0, le resultat est negatif, on decremente
		movf	num,W		; on fait l'addition du nombre negatif et du diviseur
		addwf	div,W
		movwf	reste		; on copie l'addition dans le reste
		return			; et on quitte

;****************************************************************************
;****************************************************************************

; sous-routine de complment  2 (+ affichage du signe '-')
compl2		comf	OWBUFFER, F
		incf	OWBUFFER, F
		retlw	'-'

;****************************************************************************
;***********************   routines de calcul   *****************************
;****************************************************************************


;****************************************************************************
;**********************************	init	lcd	*****************************	
;****************************************************************************

init_lcd	call	clr_lcd
		call	clr_lcd
		call	ctl_lcd		;interface 4 bits etc
		call	ctl_lcd		;interface 4 bits etc
		MOVLW	b'00001100'	;valide l'afficheur
		call	suitcom	
		GOTO	clr_lcd

;************************	routines	LCD	*******************
	
tst_busy	BCF	RS_lcd			;commande	lcd						
		CALL	in_lcd
		BTFSC	0,7	
		GOTO	tst_busy
		RETURN

ligne1		MOVLW	b'10000000'	;1eme ligne
		GOTO	suitcom

ligne2		MOVLW	b'11000000'	;2eme ligne
		GOTO	suitcom
				
ctl_lcd		MOVLW	b'00101000'	;interface 4 bits 2 lignes
		GOTO	suitcom

hom_lcd		MOVLW	b'00000010'	;0x02
		GOTO	suitcom

clr_lcd		MOVLW	1
suitcom		CALL	com_lcd
tempo		CLRF	tmp0
bcl_tp1		DECFSZ	tmp0,F							
		GOTO	bcl_tp1
		RETURN


;*********************************************************	
input		bsf	RW_lcd		;en lecture
		BSF	STATUS,RP0	;bank	1	
		BCF	STATUS,RP1	;tris register	
		BSF	D4_lcd		;data	en	entree							
		BSF	D5_lcd
		BSF	D6_lcd	
		BSF	D7_lcd	
		BCF	STATUS,RP0	;bank	0	
		BCF	STATUS,RP1
		RETURN

output		bcf	RW_lcd		;en ecriture
		BSF	STATUS,RP0	;bank	1	
		BCF	STATUS,RP1	;tris register
		BCF	D4_lcd		;data	en	sortie						
		BCF	D5_lcd
		BCF	D6_lcd	
		BCF	D7_lcd	
		BCF	STATUS,RP0	;bank	0	
		BCF	STATUS,RP1	
		RETURN
	
com_lcd		BCF	RS_lcd		;commande
		MOVWF	carlcd							
		GOTO	suitc

w_lcd		MOVWF	carlcd
car_lcd		BSF	RS_lcd		;data							
suitc		CALL	output		;positionne	TRISD et RW

out_lcd		BCF	D7_lcd					
		BCF	D6_lcd	
		BCF	D5_lcd		
		BCF	D4_lcd
		BTFSC	carlcd,7						
		BSF	D7_lcd	
		BTFSC	carlcd,6						
		BSF	D6_lcd	
		BTFSC	carlcd,5						
		BSF	D5_lcd	
		BTFSC	carlcd,4						
		BSF	D4_lcd
		BSF	E_lcd		
		BCF	E_lcd		
		BCF	D7_lcd		
		BCF	D6_lcd		
		BCF	D5_lcd		
		BCF	D4_lcd
		BTFSC	carlcd,3						
		BSF	D7_lcd	
		BTFSC	carlcd,2						
		BSF	D6_lcd	
		BTFSC	carlcd,1						
		BSF	D5_lcd	
		BTFSC	carlcd,0
		BSF	D4_lcd	
		BSF	E_lcd		
		BCF	E_lcd	
		GOTO 	tempo
	
in_lcd		CALL	input		;met	data	input	RW=1
		BSF	E_lcd		;enable	lcd	
		MOVF	PORTC,W		;lit	le	port							
		BCF	E_lcd	
		ANDLW	0xF		;masque	les	4	bits
		MOVWF	temp		;les	stock
		SWAPF	temp,F		;msb							
		BSF	E_lcd	
		MOVF	PORTC,W		;meme	chose	pour	lsb						
		BCF	E_lcd	
		ANDLW	0xF	
		IORWF	temp,W
		RETURN

;************************************************************
;******************    routine clavier        ***************
;************************************************************

clavier		bcf	PORTA,0
		movfw	PORTC
		bsf	PORTA,0
		andlw	b'00001111'
		movwf	temp
		xorlw	b'00001111'
		btfss	STATUS,Z
		goto	touche147d
		BTFSS	RX		;attend	changement sur RX
		GOTO	okRX

		bcf	PORTA,1
		movfw	PORTC
		bsf	PORTA,1
		andlw	b'00001111'
		movwf	temp
		xorlw	b'00001111'
		btfss	STATUS,Z
		goto	touche2580
		BTFSS	RX		;attend	changement sur RX
		GOTO	okRX

		bcf	PORTA,2
		movfw	PORTC
		bsf	PORTA,2
		andlw	b'00001111'
		movwf	temp
		xorlw	b'00001111'
		btfss	STATUS,Z
		goto	touche369e
		movlw	b'11111111'
		return

touche369e	btfsc	temp,0
		goto	pas3
		movlw	3
		goto	finclav

pas3		btfsc	temp,1
		goto	pas6
		movlw	6
		goto	finclav

pas6		btfsc	temp,2
		goto	pas9
		movlw	9
		goto	finclav

pas9		movlw	10
		goto	finclav

touche2580	btfsc	temp,0
		goto	pas2
		movlw	2
		goto	finclav

pas2		btfsc	temp,1
		goto	pas5
		movlw	5
		goto	finclav

pas5		btfsc	temp,2
		goto	pas8
		movlw	8
		goto	finclav

pas8		movlw	0
		goto	finclav

touche147d	btfsc	temp,0
		goto	pas1
		movlw	1
		goto	finclav

pas1		btfsc	temp,1
		goto	pas4
		movlw	4
		goto	finclav

pas4		btfsc	temp,2
		goto	pas7
		movlw	7
		goto	finclav

pas7		movlw	11
finclav		movwf	touche
		return

;************************************************************
;************************************************************
;************************************************************
;************************************************************

interrupt	BCF	INTCON,GIE		;disable ALL int

;*****************************************************
;*********** SAUVE ***********************************
;*****************************************************

		movwf	w_temp		;sauve W en 70H
		movf	STATUS,W
		clrf	STATUS		;bank 0
		movwf	status_temp	;sauve STATUS en 6fh
		movf	PCLATH,W
		movwf	pclath_temp
		clrf	PCLATH	
;*****************************************************
;*********** test quel interruption ******************	
;*****************************************************

		btfss	INTCON,INTF	;RB0 pour RX ?
		goto 	exit_isr	;oui interruption RX rs232
		BCF	INTCON,INTF	;CLEAR BIT INT RB0
exit_isr 
		clrf	STATUS		 ; ensure file register bank set to 0
		movf	pclath_temp,w
		movwf	PCLATH		;restore PCLATH
		movf	status_temp,w	;retrieve copy of STATUS register
		movwf	STATUS		;restore pre-isr STATUS register contents
		swapf	 w_temp,f	;
		swapf	 w_temp,w	; restore pre-isr W register contents
		bsf	flag,int	;signal qu'une interruption a eu lieu
		BSF	INTCON,GIE	;enable ALL int
		retfie			;return from interrupt

;***************************	routines d'envoi de caractere sur le RS232	**********	
env_cr		MOVLW	0xD	
		goto	car_TX

env_lf		MOVLW	0xA
		goto	car_TX

env_04		MOVLW	0x4
		goto	car_TX

env_car		BTFSC	flag,tx_lcd	;envoi le caractere sur TX si 0,ou LCD si 1
		goto	w_lcd		;set a 1 sur LCD		

car_TX		BTFSS	flag,rx0_tx1
		RETURN
		
		andlw	b'01111111'	;7 bits
		MOVWF	bufcar
		MOVLW	0x8		;nb	de	bits
		MOVWF	compte		;compteur	de	bits
		BCF	TX		;start	bit						
		CALL	tempo1b		;temps	pour 1 bit

bcl_TX		RRF	bufcar,F	;bit suivant							
		BTFSC	STATUS,C	;test si 1 ou 0
		GOTO	suitTX

		BCF	TX		;0					
		GOTO	suit_TX

suitTX		BSF	TX		;1					
suit_TX		CALL	tempo1b

		DECFSZ	compte,F	;1 bit	de	autres	a	traiter						
		GOTO	bcl_TX
		BSF	TX		;1er stop bit
		CALL	tempo1b
		BSF	TX		;2em stop bit fini avec tempo de 1 bit				
		goto	tempo1b

;************************************************************
	
tempo1b		MOVF	speed,W	
		MOVWF	buffer
bcl_1b		DECFSZ	buffer,F
		GOTO	bcl_1b
		RETURN
;************************************************************
	
demi_b		MOVF	speed,W	
		MOVWF	buffer
		BCF	STATUS,C
		RRF	buffer,F							
		GOTO	bcl_1b

;*******************************	DEBUT	DU	PROGRAMME	************************
	
INIT		BSF	STATUS,RP0	
		BCF	STATUS,RP1	;bank	1
		MOVLW	0xA8
		MOVWF	TMR0	
		MOVLW	b'00111000'	;o output  1 en entree
		MOVWF	TRISA	
		MOVLW	b'11000001'	; input = icd2 RB6 & RB7& RB0 IN, autres sortie uln
		MOVWF	TRISB
		MOVLW	b'10001111'	;7,RX 6,TX 4,sda in,scl out = 0,C0=>C3 = 1 input clavier
		MOVWF	TRISC	
		MOVLW	b'00000001'	;E,RS,RW,d4,d5,d6,d7 = 0 rd0=1 input
		MOVWF	TRISD
		MOVLW	b'00000111'	;E0,E1,E2, =1 input
		MOVWF	TRISE	
;		MOVLW	b'00000110'	;DIGITAL I/0  par dfaut
;		MOVWF	ADCON1		;pour 16f877
		BCF	STATUS,RP0	;bank	0							
		BCF	STATUS,RP1	
		MOVLW	b'00000111'	;0x07	
		MOVWF	PORTA
;		MOVLW	b'11111111'	;0x07	
;		MOVWF	PORTC
		
;		MOVLW	b'00000111'	;0x07 en sortie met a 1	
;		MOVWF	PORTE
		movlw	b'00000100'
		movwf	T1CON		;initialise timer T1

;----------------------------------------------------------------------		
		bcf	OW_BUS		; = niveau bas sur le bus
		CALL	init_lcd
		OW_BUS_IN
;----------------------------------------------------------------------

;autobaud	MOVLW	0		;de 4800b a 19800b
;		MOVWF	speed
;bclrs1		BTFSC	RX		;test RX						
;		GOTO	bclrs1		;toujours a 1

;bclrs2		INCF	speed,F		;mesure	la longueur du start bit							
;		nop
;		nop
;		nop
;		BTFSS	RX		;test	RX					
;		GOTO	bclrs2
;		movlw	0x10		;pour 19200
;		subwf	speed,F
;		BTFSS	STATUS,C
;		goto	ok_speed10
;		movlw	0x20		;pour 9600
;		subwf	speed,F
;		BTFSS	STATUS,C
;		goto	ok_speed20
;		movlw	0x40		;pour 4800
;		subwf	speed,F
;		BTFSS	STATUS,C
;		goto	ok_speed40
;		movlw	0x80		;pour 2400
;		subwf	speed,F
;		BTFSS	STATUS,C
;		goto	ok_speed80
;		movlw	0		;pour 1200 bauds
;		goto	ok_speed

		movfw	PORTE
		andlw	b'00000011'
		xorlw	b'00000011'
		BTFSC	STATUS,Z
		goto	ok_speed80
		movfw	PORTE
		andlw	b'00000011'
		xorlw	b'00000010'
		BTFSC	STATUS,Z
		goto	ok_speed40
		movfw	PORTE
		andlw	b'00000011'
		xorlw	b'00000001'
		BTFSC	STATUS,Z
		goto	ok_speed20
		movfw	PORTE
		andlw	b'00000011'
		xorlw	b'00000000'
		BTFSS	STATUS,Z
		goto	ok_speed20
ok_speed10	MOVLW	'1'
		CALL	w_lcd
		MOVLW	'9'
		CALL	w_lcd
		MOVLW	'2'
		CALL	w_lcd
		movlw	0x10			;19200b
		goto	ok_speed

ok_speed20	MOVLW	'9'
		CALL	w_lcd
		MOVLW	'6'
		CALL	w_lcd
		movlw	0x20			;9600b
		goto	ok_speed

ok_speed40	MOVLW	'4'
		CALL	w_lcd
		MOVLW	'8'
		CALL	w_lcd
		movlw	0x40			;4800b
		goto	ok_speed

ok_speed80	MOVLW	'2'
		CALL	w_lcd
		MOVLW	'4'
		CALL	w_lcd
		movlw	0x80			;2400b

ok_speed	movwf	speed
		MOVLW	'0'
		CALL	w_lcd
		MOVLW	'0'
		CALL	w_lcd
		MOVLW	' '
		CALL	w_lcd
		MOVLW	'B'
		CALL	w_lcd
		movlw	' '
		call	w_lcd
	
		movlw	'0'
		btfsc	PORTA,3		;switch 7
		movlw	'1'
		call	w_lcd
		movlw	'0'
		btfsc	PORTA,4		;switch 6
		movlw	'1'
		call	w_lcd
		movlw	'0'
		btfsc	PORTA,5		;switch 5
		movlw	'1'
		call	w_lcd
		movlw	'0'
		btfsc	PORTD,0		;switch 4
		movlw	'1'
		call	w_lcd
		movlw	'0'
		btfsc	PORTE,0		;switch 3
		movlw	'1'
		call	w_lcd
		movlw	'0'
		btfsc	PORTE,1		;switch 2
		movlw	'1'
		call	w_lcd
		movlw	'0'
		btfsc	PORTE,2		;switch 1
		movlw	'1'
		call	w_lcd

		
		
;		BSF	STATUS,RP0	
;		BCF	STATUS,RP1	;bank 1
;		BCF	OPTION_REG,INTEDG	;front descendant de RX RB0
;		BCF	STATUS,RP0	
;		MOVLW	b'10010000'	;VALIDE LES INTERRUPTIONS et INT RB0
;		MOVWF	INTCON
		CLRF	flag		;dvalide mission sur TX rs232	etc


retour_err	MOVLW	debbuf
		MOVWF	pointeur	;initialise l'ecriture du buffer rs232
		MOVWF	lecteur		;initialise la lecture du buffer rs232
		movlw	0
		movwf	car232
		bcf	flag,rx0_tx1	;aurorise reception bloque mission rs232
;		BCF	INTCON,INTF	;CLEAR BIT INT RB0 pour valider int rb0
;		bsf	INTCON,INTE	;valide int RB0

			
main_pg
		movlw	0		;lance le timer
		movwf	compte
		movwf	TMR1L
		movwf	TMR1H
;		bsf	T1CON,0
;		movlw	h'ff'		
;		movwf	TMR1H
		
;		bsf	T1CON,0		;valide le timer
;		movfw	TMR1H
;		xorlw	h'FF'
;		btfss	STATUS,Z
;		goto	bcl1RX		;attend fin tempo
		
		bcf	T1CON,0		;arrete le timer

;*****************	reception d'un caractere sur le RS232	**********	

car_RX		CLRF	car232	
		bcf	flag,local
bcl1RX		BTFSS	RX		;attend	changement sur RX
		GOTO	okRX

		btfsc	PORTA,3		;switch 7
		goto	tst_clav
bcl1_ir		btfss	PORTA,4		;switch 6
		goto	car_RX
		
tst_ir		btfsc	IR		;test Infra Rouge changement
		goto	bcl1RX
		bcf	flag,erreur_ir
		call	okIR
		btfsc	flag,erreur_ir
		goto	bcl1RX
		btfss	flag,flag_IR
		goto	bcl1RX
		xorlw	D'53'		;lecture
		btfsc	STATUS,Z
		goto	lectemp
		movfw	touche
		xorlw	D'07'		;lecture
		btfsc	STATUS,Z
		goto	lectemp
		movfw	touche
		xorlw	D'05'		;lecture
		btfsc	STATUS,Z
		goto	lectemp
		movfw	touche
		xorlw	D'68'		;lecture
		btfsc	STATUS,Z
		goto	lectemp
		movfw	touche
		xorlw	D'14'		;lecture
		btfsc	STATUS,Z
		goto	lectemp
		movfw	touche
		xorlw	D'17'		;lecture
		btfsc	STATUS,Z
		goto	lectemp
		movfw	touche
		xorlw	D'23'		;lecture
		btfsc	STATUS,Z
		goto	lectemp
		
		goto	main_pg		;pas lecture

lectemp		call	clr_lcd		;efface lcd
		bsf	flag,local
		call	rom_search_setup
		goto	INIT


tst_clav	call	clavier
		xorlw	b'11111111'
		btfsc	STATUS,Z

		goto	bcl1_ir

		bcf	flag,flag_IR		;commande clavier
		movfw	touche
		xorlw	10
		btfsc	STATUS,Z
		goto	suitclav
		call	clr_lcd			;efface lcd
		bsf	flag,local
		call	rom_search_setup
		goto	bcl1RX
		
suitclav	movfw	touche
		xorlw	11
		btfsc	STATUS,Z
		goto	bcl1RX
		goto	INIT			;reset et affichage bauds

;************************************************************************
;*******     dbut reception de commande infra rouge "RC5"   *****************
;************************************************************************
okIR		movlw	0
		movwf	TMR1L
		movwf	TMR1H
		movwf	touche
		bsf	T1CON,0
ir_00		btfss	IR
		goto	ir_00
		bcf	T1CON,0
		movfw	TMR1H
		xorlw	3
		btfsc	STATUS,Z
		goto	ok_RC5
		
		movfw	TMR1H		;pas RC5 NEC ?
		xorlw	D'35'
		btfsc	STATUS,Z
		goto	ok_NEC
		
		bsf	flag,erreur_ir	;autre protocol
		return

ok_NEC		call	ligne2		;lcd
		movlw	1
		movwf	temp
ir_02		btfsc	IR		;attend 3em front montant
		goto	ir_02
		decfsz	temp,F
		goto	ir_021
		goto	ok__NEC

ir_021		btfss	IR		;attend 3em front montant
		goto	ir_021
		goto	ir_02

ok__NEC		movlw	4
		movwf	compte
deb2		movlw	8
		movwf	temp
		movfw	tmp2
		movwf	tmp3
		movfw	tmp1
		movwf	tmp2
		movfw	tmp0
		movwf	tmp1
		movlw	0
		movwf	tmp0

deb1		movlw	0
		movwf	TMR1L
		movwf	TMR1H
		bsf	T1CON,0
ir_03		btfss	IR
		goto	ir_03
ir_04		movfw	TMR1H
		btfsc	STATUS,Z
		goto	escape_ir
		
		btfsc	IR
		goto	ir_04
		bcf	T1CON,0
		bsf	tmp0,0
		movlw	7
		subwf	TMR1H,W		;8="1"
		btfss	STATUS,C
		bcf	tmp0,0
		rrf	tmp0,F
		decfsz	temp,F
		goto	deb1
		decfsz	compte,F
		goto	deb2

escape_ir	movfw	tmp1
		andwf	tmp0,F		;verifie si valide
		btfss	STATUS,Z	;tmp0 complement de tmp1
		return
		
		bsf	flag,flag_IR
		movwf	touche		;ok		
		return
		

ok_RC5		bsf	flag,flag_IR	;signale commande IR
;		movlw	0
;		movwf	TMR1L
;		movwf	TMR1H
;		bsf	T1CON,0
ir_01;		movfw	TMR1L
;		btfss	STATUS,Z
;		goto	suit_01
;		movfw	TMR1H
;		btfsc	STATUS,Z
;		goto	escape_ir
suit_01		btfsc	IR
		goto	ir_01
		movlw	3
		movwf	compte
		call	t222	;222s 1/8 bit
deb0		movlw	8
		movwf	temp
		movfw	tmp2
		movwf	tmp3
		movfw	tmp1
		movwf	tmp2
		movfw	tmp0
		movwf	tmp1
deb		call	t222	;889s un demi bit
		call	t222
		call	t222
		call	t222
		bsf	tmp0,0
		btfss	IR
		bcf	tmp0,0
		rlf	tmp0,F
		decfsz	temp,F
		goto	deb
		decfsz	compte,F
		goto	deb0
		
fin_IR		bcf	touche,5
		btfsc	tmp1,3		;msb
		bsf	touche,5
		bcf	touche,4
		btfsc	tmp1,1		;msb
		bsf	touche,4
		bcf	touche,3
		btfsc	tmp0,7		;msb
		bsf	touche,3
		bcf	touche,2
		btfsc	tmp0,5		;msb
		bsf	touche,2
		bcf	touche,1
		btfsc	tmp0,3		;msb
		bsf	touche,1
		bcf	touche,0
		btfsc	tmp0,1		;msb
		bsf	touche,0
		movfw	touche
		return


; Temporisation de 222 s
; 3s par itrations, donc 74*3 = 222 s
; +2s pour l'initialisation (ngligeable)
t222		movlw	D'69'		;ok 70 normal 222s =74'
		movwf	cmpt
		goto	sub_t480
		
sub_t222	decfsz	cmpt,f
		goto	sub_t222
		return
		
;************************************************************************
;*******     dbut reception d'un caractre rs232    ********************
;************************************************************************

okRX		CALL	demi_b

		MOVLW	0x8		;nb	de	bits	
		MOVWF	compte
bcl2RX		CALL	tempo1b

		BCF	STATUS,C	;carry a 0
		BTFSC	RX		;test	si 1 ou	0						
		BSF	STATUS,C	;met le bit a 1
		RRF	car232,F	;construit le caractere lsb first							
		DECFSZ	compte,F	;un bit aprs l'autres							
		GOTO	bcl2RX
			
		bcf	car232,7	;utilise les 7 bits de poids faibles
		MOVFW	pointeur
		MOVWF	FSR		;pointeur
		MOVFW	car232
		MOVWF	INDF		;ecrit a l'adresse pointe
		INCF	pointeur,F	;pointe a l'adresse suivante
		movwf	temp
		MOVLW	cr		;end of transmision pour fin de commande ?
		XORWF	temp,W
		BTFSC	STATUS,Z
		goto	buf_rx		;recu une commande dans le buffer RX rs232
		MOVLW	lf		;end of transmision pour fin de commande ?
		XORWF	temp,W
		BTFSC	STATUS,Z
		goto	buf_rx		;recu une commande dans le buffer RX rs232
		goto	main_pg		;pour mettre a jour

;*****************************************************
;*****************************************************
;*****************************************************
;*****************************************************
;*** TRAITEMENT DU BUFFER DE RECEPTION ***************
;*****************************************************
buf_rx		bcf	flag,local	;commande par RS232
;		call	ligne1
		bsf	flag,rx0_tx1	;valide TX
;		bcf	INTCON,INTE	;arrete interruption RBO RX
bcl_buf		call	pr_car_buf
		movwf	temp
		MOVLW	0x7f		;caractere de syncro autobaud ?
		XORWF	temp,W
		BTFSC	STATUS,Z
		goto	bcl_buf
		decf	lecteur,F
		call	pr_2_dig
		btfsc	flag,car_ctrl	;control
		goto	fin_com
		movwf	temp
r_car_rs	MOVLW	adresse		;adresse du module
		XORWF	temp,W		;compare avec le 1er octet
		BTFSS	STATUS,Z						
		GOTO	zap_com		;pas l'adresse de cette carte on fait suivre
			
suit_com	call	pr_2_dig	;prend commande 2 digits
		btfsc	flag,car_ctrl	;control
		goto	fin_com
		movwf	temp
;		MOVLW	cr		;caractere de fin de commande
;		XORWF	temp,W		;compare avec le 1er octet
;		BTFSC	STATUS,Z	;voir adresse		
;		goto	fin_com
;		MOVLW	lf		;caractere de fin de commande
;		XORWF	temp,W		;compare avec le 1er octet
;		BTFSC	STATUS,Z	;voir adresse		
;		goto	fin_com
;		movfw	temp
		goto	tabcom		;saut a la commande

deb_com		movwf	temp1
		movlw	master		;par dfaut 0
		call	env_2_dig	;envoi 2 digits sur rs232
		movfw	temp1
		goto	env_2_dig	;envoi 2 digits sur rs232 et retour

zap_com		movfw	temp		;envoi l'adresse
		call	env_2_dig	;sur RS 232
suit_zap	call	pr_car_buf
		call	car_TX
		movwf	temp
		MOVLW	lf		;caractere fin de transmission
		XORWF	temp,W		;compare avec le 1er octet
		BTFSC	STATUS,Z	;fin du buffer fin commande		
		goto	retour_err
		MOVLW	lf		;caractere fin de transmission
		XORWF	temp,W		;compare avec le 1er octet
		BTFSC	STATUS,Z	;fin du buffer fin commande		
		goto	retour_err
		GOTO	suit_zap	;syncro on zap
		
fin_com		bcf	flag,car_ctrl	;annule dtection caractere inf a 30h
		call	env_cr		;envoi cr rs232
		call	env_lf		;envoi rs232
		call	env_04
		goto	retour_err	;init buffer		

;*********************************************************************************************
;one wire dallas DS18B20
;init rom search

rom_search1				;18h 24
		movlw	.10		;renvoi la commande
		call	deb_com
rom_search_setup
		clrw
		movwf	c_dif			;derniere difference last discrepancy
		movwf	c1_dif			;derniere difference last discrepancy
		movwf	nb_ibuttons		;nb de ibutton trouv
		movwf	flagx			;flags d'tats et d'erreurs
ib_suivant1	call	rom_search		;cherche un ibutton
		btfsc	flagx,er_one_wire	;erreur pas de prsence
		goto	saute_ibutton1		;oui
		btfsc	flagx,er_crc		;erreur de crc
		goto	rom_search_setup	;oui
		btfss	flagx,vrai		;trouv un ibutton ?
		goto	rom_search_setup	;non			
		incf	nb_ibuttons,f

;*************************  modif  *******************
temperature	call	ligne1
		movfw	nb_ibuttons
		btfss	flag,local		;fonctionnement avec clavier ?
		goto	rs_0			;non
		bsf	flag,tx_lcd		;on affiche valeure > lcd
		call	env_2_dig		;envoi 2 digits sur lcd
		call	match_rom		;selectionne le ds18b20
		call	convert_T		;lance une saisie de temprature
		call	match_rom		;selectionne le ds18b20
		call	Read_scratchpad		;lit le scratchpad
		bsf	flag,tx_lcd		;on affiche valeure > lcd
; mise en forme dans une seule variable
		movfw	OWBUFFER1		;lsb
		swapf	OWBUFFER2, F		;lsb msb
		movlw	B'11110000'
		andwf	OWBUFFER2,F		;msb msb
		swapf	OWBUFFER1, W		;msb lsb
		andlw	B'00001111'
		iorwf	OWBUFFER2,F		;lsb lsb

; gestion du signe ngatif '-'
		movlw	' '
		btfsc	OWBUFFER2,7
		call	compl2
		CALL	w_lcd		;affiche espace ou "-"
		movfw	OWBUFFER2
		movwf	num
		call	ascii8
		movlw	'0'
		xorwf	cent,w
		btfsc	STATUS,Z
		goto	saute100
		movf	cent, W
		CALL	w_lcd
saute100	movf	diz, W
		CALL	w_lcd
		movf	unit, W
		call	w_lcd
		movlw	','
		CALL	w_lcd
	
;pour les diximes,centimes,millimes de degrs
		clrf	num
		btfsc	OWBUFFER1,0
		call	add_06
		btfsc	OWBUFFER1,1
		call	add_12	
		btfsc	OWBUFFER1,2
		call	add_25	
		btfss	OWBUFFER1,3
		goto	suit_dix
		
add_50		movlw	d'50'
		addwf	num,F
		goto	suit_dix
add_25		movlw	d'25'
		goto	fin_add
add_12		movlw	d'12'
		goto	fin_add
add_06		movlw	d'6'
fin_add		addwf	num,F
		return


; ****************************************************************************

suit_dix	movlw	D'10'
		movwf	div
		call	div8
		movlw	B'00110000'		; masque correspondant aux nombres decimaux dans la table ASCII
		iorwf	result,w
		CALL	w_lcd
		movlw	' '
		CALL	w_lcd
		movlw	3
		movwf	tmp1
		movlw	OWBUFFER3
		movwf	FSR
next11		movfw	INDF
		bsf	flag,tx_lcd		;on affiche valeure > lcd
		call	env_2_dig		;envoi 2 digits sur lcd
		incf	FSR,f
		decfsz	tmp1,f
		goto	next11
		movfw	OWBUFFER1a
		movwf	OWBUFFER1		
		movfw	OWBUFFER2a
		movwf	OWBUFFER2		
		movfw	OWBUFFER3a
		movwf	OWBUFFER3		
		movfw	OWBUFFER4a
		movwf	OWBUFFER4		
		movfw	OWBUFFER5a
		movwf	OWBUFFER5		
		movfw	OWBUFFER6a
		movwf	OWBUFFER6		
		movfw	OWBUFFER7a
		movwf	OWBUFFER7		
		movfw	OWBUFFER8a
		movwf	OWBUFFER8		

;*************************  modif  *******************

		call	ligne2
		goto	rs_1

rs_0		movfw	nb_ibuttons
		bcf	flag,tx_lcd		;on affiche valeure > TX
		call	env_2_dig		;envoi 2 digits sur rs232

rs_1		movlw	8
		movwf	tmp1
		movlw	OWBUFFER1
		movwf	FSR
next0		movfw	INDF
		btfss	flag,local
		goto	rs_2
		bsf	flag,tx_lcd		;on affiche valeure > lcd
		call	env_2_dig		;envoi 2 digits sur lcd
		goto	lcd_1

rs_2		movfw	INDF
		bcf	flag,tx_lcd		;on affiche valeure > TX
		call	env_2_dig		;envoi 2 digits sur rs232
lcd_1		incf	FSR,f
		decfsz	tmp1,f
		goto	next0

		call	ResetBUS
		call	ligne1
		btfss	flag,local
		goto	rs_3			;****** distant *************
		
;******************************************************  local  *************
		btfsc	flag,flag_IR
		goto	ir			;ir
		
bclclav		call	t480			;clavier
		call	clavier
		xorlw	b'11111111'		;attend que la touche ai t lache
		btfss	STATUS,Z
		goto	bclclav
		movlw	0
		movwf	TMR1L
		movwf	TMR1H
		bsf	T1CON,0		;valide le timer
bclclav1	movfw	TMR1H
		xorlw	H'E8'
		btfsc	STATUS,Z
		goto	temperature
		call	clavier
		xorlw	b'11111111'		;attend q'une touche ai t rappuye
		btfss	STATUS,Z
		goto	appuyer
		goto	bclclav1
		
appuyer		movfw	touche
		xorlw	D'17'
		btfsc	STATUS,Z
		goto	temperature
		movfw	touche
		xorlw	D'16'
		btfsc	STATUS,Z
		goto	lcd_2
		return
		
ir		btfsc	IR
		goto	ir
		call	okIR
		bsf	flag,erreur_ir
		xorlw	D'53'		;arret image "pause"
		btfsc	STATUS,Z
		goto	temperature	;lecture
		movfw	touche
		xorlw	D'41'		;arret image "pause"
		btfsc	STATUS,Z
		goto	temperature	;lecture
		movfw	touche
		xorlw	D'21'		;arret image "pause"
		btfsc	STATUS,Z
		goto	temperature	;lecture
		movfw	touche
		xorlw	D'35'		;arret image "pause"
		btfsc	STATUS,Z
		goto	temperature	;lecture
		movfw	touche
		xorlw	D'07'		;arret image "pause"
		btfsc	STATUS,Z
		goto	temperature	;lecture
		movfw	touche
		xorlw	D'68'		;arret image "pause"
		btfsc	STATUS,Z
		goto	temperature	;lecture
		movfw	touche
		xorlw	D'23'		;arret image "pause"
		btfsc	STATUS,Z
		goto	temperature	;lecture
		movfw	touche
		xorlw	d'38'		;ibutton suivant ">>"
		btfsc	STATUS,Z
		goto	lcd_2
		movfw	touche
		xorlw	d'64'		;ibutton suivant ">>"
		btfsc	STATUS,Z
		goto	lcd_2
		movfw	touche
		xorlw	d'69'		;ibutton suivant ">>"
		btfsc	STATUS,Z
		goto	lcd_2
		movfw	touche
		xorlw	d'67'		;ibutton suivant ">>"
		btfsc	STATUS,Z
		goto	lcd_2
		movfw	touche
		xorlw	d'14'		;ibutton suivant ">>"
		btfsc	STATUS,Z
		goto	lcd_2
		movfw	touche
		xorlw	d'18'		;ibutton suivant ">>"
		btfsc	STATUS,Z
		goto	lcd_2
		movfw	touche
		xorlw	d'06'		;ibutton suivant ">>"
		btfsc	STATUS,Z
		goto	lcd_2
		movfw	touche
		xorlw	d'54'		;ibutton "arret"
		btfsc	STATUS,Z
		return
		movfw	touche
		xorlw	d'26'		;ibutton "arret"
		btfsc	STATUS,Z
		return
		movfw	touche
		xorlw	d'22'		;ibutton "arret"
		btfsc	STATUS,Z
		return
		movfw	touche
		xorlw	d'04'		;ibutton "arret"
		btfsc	STATUS,Z
		return
		movfw	touche
		xorlw	d'06'		;ibutton "arret"
		btfsc	STATUS,Z
		return
		goto	ir
		
rs_3		call	env_cr
		call	env_lf
lcd_2		btfss	flagx,fini		;dernier ibutton ?
		goto	ib_suivant1		;non
		
;*********************************************************************************
saute_ibutton1	goto	fin_com

;*********************************************************************************

r_match_R	;19h 25
		movlw	.11		;renvoi la commande 
		call	deb_com
		call	match_r		;selectionne le ds18b20
		call	convert_T	;lance une saisie de temprature
		call	match_rom	;selectionne le ds18b20
		call	Read_scratchpad	;lit le scratchpad
		movlw	8
		movwf	tmp1
		movlw	OWBUFFER1
		movwf	FSR
next1		movfw	INDF
		bcf	flag,tx_lcd	;on affiche valeure > TX
		call	env_2_dig	;envoi 2 digits sur rs232
		incf	FSR,f
		decfsz	tmp1,f
		goto	next1
		call	ResetBUS
		goto	fin_com
			
r_match_W	;1Ah 26
		movlw	.12		;renvoi la commande
		call	deb_com
		call	match_r		;commande
		call	pr_2_dig	;commande 
		movwf	OWBUFFER1
		call	pr_2_dig	;commande 
		movwf	OWBUFFER2
		call	pr_2_dig	;commande 
		movwf	OWBUFFER3
		call	write_scratchpad
		goto	fin_com		;oui

copy_EE		;1Bh 27
		movlw	.13		;renvoi la commande
		call	deb_com
		call	match_r		;commande
		call	copy		;commande
		goto	fin_com

recall_EE	;1Ch 28
		movlw	.14			;renvoi la commande
		call	deb_com
		call	match_r		;commande
		call	recall	;commande
		goto	fin_com

r_power		;1Dh 29
		movlw	.15			;renvoi la commande
		call	deb_com
		call	read_power
		call	env_2_dig	;envoi 2 digits sur rs232
		goto	fin_com



ram_r		movlw	master		;par dfaut 0
		call	env_2_dig	;envoi 2 digits sur rs232
		movlw	.1
		call	env_2_dig	;envoi 2 digits sur rs232
		call	pr_2_dig	;adresse concerne
		btfsc	flag,car_ctrl	;control
		goto	fin_com
		call	env_2_dig	;envoi rs232
		call	pr_dat_ram	;valeur data
		goto	fin_r_w


ram_w		movlw	master		;par dfaut 0
		call	env_2_dig	;envoi 2 digit sur rs232
		movlw	.0			;renvoi la commande write
		call	env_2_dig	;envoi 2 digits sur rs232
		call	pr_2_dig	;adresse concerne
		btfsc	flag,car_ctrl	;control
		goto	fin_com
		call	env_2_dig	;envoi rs232
		call	pr_2_dig	;data > adresse concerne
		btfsc	flag,car_ctrl	;control
		goto	fin_com
		movwf	temp1
		call	put_dat_ram	;valeur data
		movfw	temp1
fin_r_w		call	env_2_dig	;envoi rs232
		call	env_cr
		goto	suit_com	;pour suite buffer et commande suivante
			
lcddat_w	movlw	master		;par dfaut 0
		call	env_2_dig	;envoi 2 digit sur rs232
		movlw	.8			;renvoi la commande write
		call	env_2_dig	;envoi 2 digits sur rs232
suit_dat_w	call	pr_car_buf	;data > lcd
		movwf	temp1
		MOVLW	cr			;caractere de fin de commande
		XORWF	temp1,W		;compare avec le 1er octet
		BTFSC	STATUS,Z	;voir adresse		
		goto	fin_com
		MOVLW	lf			;caractere de fin de commande
		XORWF	temp1,W		;compare avec le 1er octet
		BTFSC	STATUS,Z	;voir adresse		
		goto	fin_com
		movfw	temp1
		call	w_lcd		;valeur > data
		movfw	temp1
		call	car_TX
		goto	suit_dat_w

lcdcom_w	movlw	master		;par dfaut 0
		call	env_2_dig	;envoi 2 digit sur rs232
		movlw	.6			;renvoi la commande LCD com
		call	env_2_dig	;envoi 2 digits sur rs232
		call	pr_2_dig	;commande > lcd
		btfsc	flag,car_ctrl		;control
		goto	fin_com
		movwf	temp1
		call	suitcom		;valeur > commande
fin_ligx	movfw	temp1
		goto	fin_r_w


eedata_w
eedata_r
prog_w
prog_r
lcdcom_r
lcddat_r


pr_dat_ram	movfw	temp
		movwf	FSR			;traite l'adresse
		movfw	INDF		;lit la ram
		return

put_dat_ram	movfw	temp		;adresse
		movwf	FSR			;traite l'adresse
		movfw	temp1		;data
		movwf	INDF		;ecrit dans la ram
		return

pr_car_buf	movfw	lecteur		;pointeur buffer rs232
		movwf	FSR			;traite l'adresse
		movfw	INDF
		incf	lecteur,F
		return

pr_2_dig	call	pr_car_buf
		call	dig_hex		;retour valeur dans temp1
		btfsc	flag,car_ctrl	;control
		goto	car_ctrol
		swapf	temp1,F		;msb
		movfw	temp1		;dans
		movwf	temp2		;temp
		call	pr_car_buf
		call	dig_hex	;retour valeur dans temp1
		btfsc	flag,car_ctrl	;control
		goto	car_ctrol
		movfw	temp1	;lsb		
		iorwf	temp2,W	;prend les msb +lsb
car_ctrol	return

dig_hex		movwf	temp1
		movlw	0x30
		subwf	temp1,W
		BTFSS	STATUS,C		
		goto 	control		;inferieur a 30h donc pas ascii
		movwf	temp1		;on recupere le rsultat de la soustraction	
		movlw	0x10
		subwf	temp1,W
		BTFSS	STATUS,C		
		return				;inferieur a 10d donc ok

		movlw	0x11
		subwf	temp1,W
		BTFSS	STATUS,C		
		goto 	dig_er		;inferieur a 11h donc pas ascii
		movlw	0x7
		subwf	temp1,F
		movlw	0x10
		subwf	temp1,W
		BTFSS	STATUS,C
		return				;inferieur a 10hdonc ascii			

control		bsf	flag,car_ctrl		;signal caractere de control
		return
dig_er							;message d'dig_er
		goto	retour_err

env_2_dig	movwf	temp
		swapf	temp,W
		andlw	b'00001111'		;msb
		call	HEX_DIG
		btfsc	flag,tx_lcd		;on affiche valeure > lcd
		goto	env_lcd1		;oui
		call	car_TX
suit_env	movfw	temp
		andlw	b'00001111'		;lsb
		call	HEX_DIG
		btfss	flag,tx_lcd		;on affiche valeure > lcd
		goto	car_TX			;non
		goto	w_lcd

env_lcd1	call	w_lcd
		goto	suit_env


		END


